<!-- Developer Studio Live Code -->
<?php
ini_set("display_errors", 0);
ini_set("display_startup_errors", 0);
error_reporting(32767);

// Conecta ao banco SQLite
$db = new SQLite3("./api/.ansdb.db");

// Cria a tabela se não existir
$db->exec("
    CREATE TABLE IF NOT EXISTS ibo(
        id INTEGER PRIMARY KEY NOT NULL,
        mac_address VARCHAR(100),
        key VARCHAR(100),
        username VARCHAR(100),
        password VARCHAR(100),
        expire_date VARCHAR(100),
        dns VARCHAR(100),
        epg_url VARCHAR(100),
        title VARCHAR(100),
        url VARCHAR(100),
        type VARCHAR(100)
    )
");

// Processa submissão do formulário
if (isset($_POST["submit"])) {
    $we = strtotime($_POST["expire_date"]);
    $ne = date("Y-m-d", $we);

    if ($_POST["type"] == "0") {
        $line = $_POST["dns"] . "/get.php?username=" . $_POST["username"] . "&password=" . $_POST["password"] . "&type=m3u_plus&output=ts";
    } else {
        $line = $_POST["url"];
    }

    $address1 = strtoupper($_POST["mac_address"]);

    $db->exec("
        INSERT INTO ibo(
            mac_address, key, username, password, expire_date, dns, epg_url, title, url, type
        ) VALUES (
            '$address1', '{$_POST["key"]}', '{$_POST["username"]}', '{$_POST["password"]}', '$ne',
            '{$_POST["dns"]}', '{$_POST["epg_url"]}', '{$_POST["title"]}', '$line', '{$_POST["type"]}'
        )
    ");

    $db->close();
    header("Location: users.php");
    exit;
}

// Inclui header
include "includes/header.php";
?>

<div class="container-fluid">
    <!-- Page Heading -->
    <h1 class="h3 mb-1 text-gray-800">Ativar</h1>

    <!-- User Details Card -->
    <div class="card border-left-primary shadow h-100 mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary"><i class="fas fa-user"></i> User Info</h6>
        </div>
        <div class="card-body">
            <form method="post">
                <!-- Device ID -->
                <div class="form-group">
                    <label for="mac_address"><strong>Mac ID</strong></label>
                    <div class="input-group">
                        <input class="form-control mac_address text-primary" id="description" name="mac_address" placeholder="Coloque Seu Mac" type="text" maxlength="17" required/>
                    </div>
                </div>

                <!-- Device Key -->
                <div class="form-group">
                    <label for="key"><strong>Senha Key</strong></label>
                    <div class="input-group">
                        <input class="form-control key text-primary" name="key" placeholder="Senha do Unitv 123456" type="text" maxlength="17" required/>
                    </div>
                </div>

                <!-- Server Name -->
                <div class="form-group">
                    <label for="title"><strong>Server Name</strong></label>
                    <div class="input-group">
                        <input type="text" class="form-control text-primary" name="title" placeholder="Enter Server Name" required/>
                    </div>
                </div>

                <!-- Xtream Codes Fields -->
                <div class="active1">
                    <div class="form-group">
                        <label for="username"><strong>Username</strong></label>
                        <div class="input-group">
                            <input type="text" class="form-control text-primary" name="username" placeholder="Enter Username"/>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="password"><strong>Password</strong></label>
                        <div class="input-group">
                            <input type="text" class="form-control text-primary" name="password" placeholder="Enter Password"/>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="dns"><strong>DNS</strong></label>
                        <div class="input-group">
                            <input type="text" class="form-control text-primary" name="dns" placeholder="Enter DNS Server"/>
                        </div>
                    </div>
                </div>

                <!-- M3U Fields -->
                <div class="active2">
                    <div class="form-group">
                        <label for="url"><strong>List M3U</strong></label>
                        <div class="input-group">
                            <input type="text" class="form-control text-primary" name="url" placeholder="Enter Url List M3U"/>
                        </div>
                    </div>
                </div>

                <!-- Expiration -->
                <div class="form-group">
                    <label for="expire_date"><strong>Expiration</strong></label>
                    <div class="input-group">
                        <input type="text" class="form-control text-primary" name="expire_date" placeholder="YYYY-MM-DD" id="datetimepicker" autocomplete="off"/>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="form-group">
                    <button class="btn btn-success btn-icon-split" name="submit" type="submit">
                        <span class="icon text-white-50"><i class="fas fa-check"></i></span>
                        <span class="text">Submit</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include "includes/footer.php"; ?>

<script>
// Alterna visibilidade dos formulários conforme tipo
$('.active1').show();
$('.active2').hide();

$(document).ready(function(){
    $('.type').change(function(){
        if($('.type').val() < 1) {
            $('.active1').show();
            $('.active2').hide();
        } else {
            $('.active2').show();
            $('.active1').hide();
        }
    });
});

// Modal Confirm Delete
$('#confirm-delete').on('show.bs.modal', function(e) {
    $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
});

// Formata MAC Address
document.getElementById("description").addEventListener('keyup', function() { 
    var mac = document.getElementById('description').value;
    var macs = mac.split(':').join('');
    macs = chunk(macs, 2).join(':');
    document.getElementById('description').value = macs.toString();
});

function chunk(str, n) {
    var ret = [];
    for(var i = 0; i < str.length; i += n) {
        ret.push(str.substr(i, n));
    }
    return ret;
}
</script>
